' RS_LINE.BAS

Option Explicit

Dim FatalFlag As Integer
Dim Code As Integer

Sub Aborting ()
  Dim Code As Integer
  RS232.Print "Fatal Error, Aborting..."
  Code = SioDone(ThePort)
  End
End Sub

Sub DisplayChar (ByVal C As Integer)
  Dim Row As Integer
  Dim Col As Integer
  C = &H7F And C
  'process char
  If C = 13 Then
    'carriage control
    CurrentCol = 0
    'plus assumed line feed
    If CurrentRow < 23 Then
      CurrentRow = CurrentRow + 1
      'print CR+LF
      RS232.Print
    Else
      'scroll !
      RS232.Cls
      For Row = 0 To 22
        'print row
        ScreenBuffer(Row) = ScreenBuffer(Row + 1)
        RS232.Print ScreenBuffer(Row)
      Next Row
      'clear bottom row
      ScreenBuffer(23) = Space$(80)
    End If
  ElseIf C = 10 Then
    'throw away line feeds
  Else
    'not CR or LF
    CurrentCol = CurrentCol + 1
    If CurrentCol > 79 Then
      'throw away !
      Exit Sub
    Else
      'save in screen buffer
      Mid$(ScreenBuffer(CurrentRow), CurrentCol, 1) = Chr$(C)
      'display character
      If DataFlag = 0 Then
        RS232.Print Chr$(C);
      Else
        RS232.Print Hex$(C);
      End If
    End If
  End If
End Sub

Sub DisplayString (Text As String)
  Dim i As Integer
  Dim Length As Integer
  Length = Len(Text)
  For i = 1 To Length
    Call DisplayChar(Asc(Mid$(Text, i, 1)))
  Next i
  Call DisplayChar(13)
End Sub

Sub GetIncoming ()
  Dim i As Integer
  Dim Buffer As String * 1024
  Dim Count As Integer
  Count = SioGets(ThePort, Buffer, 1024)
  If Count > 0 Then
    For i = 1 To Count
      Call DisplayChar(Asc(Mid$(Buffer, i, 1)))
    Next i
  End If
End Sub

Sub GoOffLine ()
  Dim Code As Integer
  RS232.menuPort.Enabled = True
  RS232.menuStatus.Enabled = False
  RS232.menuControl.Enabled = False
  RS232.menuFlow.Enabled = False
  OnLineFlag = 0
  'shut down port
  Code = SioDone(ThePort)
End Sub

Sub GoOnLine ()
  Dim i As Integer
  Dim RxQueSize As Integer
  Dim TxQueSize As Integer
  If OnLineFlag Then
    Exit Sub
  End If
  'reset the port (1024 byte RX buffer & 512 byte TX buffer)
  RxQueSize = 1024
  TxQueSize = 512
  Code = SioReset(ThePort, RxQueSize, TxQueSize)
  If Code < 0 Then
    Call SayError(RS232, Code)
    Exit Sub
  End If
  'set baud rate
  Code = SioBaud(ThePort, TheBaudCode)
  'call Aborting() if detect error after resetting port
  Call DisplayString("[COM" + LTrim$(Str$(1 + ThePort)) + " reset]")
  ' set parms
  Code = SioParms(ThePort, TheParity, TheStopBits, TheDataBits)
  'set DTR
  Code = SioDTR(ThePort, Asc("S"))
  RS232.menuSetDTR.Enabled = False
  RS232.menuSetDTR.Checked = True
  RS232.menuClearDTR.Enabled = True
  RS232.menuClearDTR.Checked = False
  'set RTS
  Code = SioRTS(ThePort, Asc("S"))
  RS232.menuSetRTS.Enabled = False
  RS232.menuSetRTS.Checked = True
  RS232.menuClearRTS.Enabled = True
  RS232.menuClearRTS.Checked = False
  ' we're online !
  OnLineFlag = 1
  RS232.menuPort.Enabled = False
  RS232.menuStatus.Enabled = True
  RS232.menuControl.Enabled = True
  RS232.menuFlow.Enabled = True
End Sub

Sub SetBaud ()
Dim Code As Integer
'Baudrate can be changed while running
Code = SioBaud(ThePort, TheBaudCode)
End Sub

Sub ShowConfig ()
  Dim A As String
  Dim B As String
  Dim C As String
  Dim D As String
  Dim E As String
  If OnLineFlag Then
    A = " (Online)"
  Else
    A = " (Offline)"
  End If
  B = "COM" + LTrim$(Str$(ThePort + 1))
  C = " @ " + BaudRateTable(TheBaudCode) + " "
  D = Str$(TheDataBits) + ParityText(TheParity)
  If TheStopBits = 0 Then
    E = "1"
  Else
    E = "2"
  End If
  RS232.Caption = "RS232: " + B + C + D + E + A
End Sub

